<?php

namespace Oneweb\SimuladorSitef;

class Config
{
    private array $parametros;

    public function __construct(array $parametros = [])
    {
        $this->parametros = $parametros;
    }

    public function arquivoRequisicao(): string
    {
        return $this->getPastaBase() . '/Req/IntPos.001';
    }

    public function pastaReq(): string
    {
        return $this->getPastaBase() . '/Req';
    }

    public function pastaResp(): string
    {
        return $this->getPastaBase() . '/Resp';
    }

    public function getUSleepTime(): int
    {
        return $this->parametros['usleep'] ?? 1000000;
    }

    private function getPastaBase(): string
    {
        return isset($this->parametros['pasta']) ? realpath($this->parametros['pasta']) : '/tmp';
    }

    public function deveNegar(): bool
    {
        return array_key_exists('negar', $this->parametros);
    }

    public function deveAutorizar(): bool
    {
        return array_key_exists('autorizar', $this->parametros);
    }
}
