<?php
require_once "vendor/autoload.php";

use Oneweb\SimuladorSitef\Config;
use Oneweb\SimuladorSitef\IoEcho;
use Oneweb\SimuladorSitef\ProcessarArquivos;
use Phalcon\Cop\Parser;

$parser = new Parser();
$params = $parser->parse($argv);
$config = new Config($params);
$io = new IoEcho();

if (!is_dir($config->pastaReq())) {
    if (!mkdir($config->pastaReq())) {
        throw new RuntimeException('Não foi possível criar a pasta ' . $config->pastaReq());
    }
}

if (!is_dir($config->pastaResp())) {
    if (!mkdir($config->pastaResp())) {
        throw new RuntimeException('Não foi possível criar a pasta ' . $config->pastaResp());
    }
}

$io->out('Pasta Req: ' . $config->pastaReq());
$io->out('Pasta Resp: ' . $config->pastaResp());
$io->out();

$processo = new ProcessarArquivos($config, $io);
$processo->processar();