<?php

namespace Oneweb\SimuladorSitef;

class ProcessarArquivos
{
    private Config $config;

    private IoInterface $io;
    private GerarConfirmacao $gerar;

    public function __construct(Config $config, IoInterface $io)
    {
        $this->config = $config;
        $this->io = $io;
    }

    public function processar(): void
    {
        //@phpstan-ignore-next-line
        while (true) {
            $this->io->out("Aguardando arquivo {$this->config->arquivoRequisicao()}");
            $this->io->out();

            while (!file_exists($this->config->arquivoRequisicao())) {
                usleep($this->config->getUSleepTime());
            }

            $conteudo = file_get_contents($this->config->arquivoRequisicao());
            $this->io->out('Arquivo recebido: ');
            $this->io->out($conteudo);
            $this->io->out();
            $arquivoBase = new Arquivo($conteudo);
            $this->gerar = new GerarConfirmacao($arquivoBase, $this->io);
            unlink($this->config->arquivoRequisicao());

            $conteudo = $this->gerar->getConfirmacao();
            $this->io->out('Gravando arquivo ' . $this->config->pastaResp() . '/IntPos.STS');
            file_put_contents($this->config->pastaResp() . '/IntPos.STS', $conteudo);
            $this->io->out();
            $this->io->out($conteudo);
            $this->io->out();

            if ($arquivoBase->deveGerarArquivoRetorno()) {
                usleep($this->config->getUSleepTime());
                //gera arquivo P4
                $conteudo = $this->gerar->getRespostaRequisicao();
                file_put_contents($this->config->pastaResp() . '/IntPos.001', $conteudo);
                $this->io->out('Gravando arquivo ' . $this->config->pastaResp() . '/IntPos.001');
                $this->io->out();
                $this->io->out($conteudo);
                $this->io->out();
            }
        }
    }
}
