const fs = require('fs');
const path = require('path');
const os = require('os');

exports.init = function (socketio, config) {
    new Sitef(socketio, config);
};

class Sitef {

    constructor(socketio, config) {
        this.pastasLogCriadas = false;
        this.socketio = socketio;
        this.isWindows = !/linux/.test(os.platform());
        this.config = config;
        if (!this.config.pastaLogs) {
            this.config.pastaLogs = 'C:/onehost/socketio/logs/';
        }

        if (!this.config.pastaBase) {
            this.config.pastaBase = 'C:/onehost/socketio';
        }
        this.adicionarEventos();
    }

    adicionarEventos() {
        this.log('Adicionando eventos');
        var self = this;
        this.socketio.on('sitef_criar_arquivo', function (data) {
            self.log('Recebido sitef_criar_arquivo chamando método criarArquivo ' + JSON.stringify(data));
            self.criarArquivo(data);
        });

        this.socketio.on('sitef_tratar_queda_energia', function () {
            self.log('Recebido sitef_tratar_queda_energia chamando método verificarArquivoP4');
            self.verificarArquivoP4();
        });

        this.socketio.on('sitef_confirmar_impressao', function (data) {
            self.log('Recebida sitef_confirmar_impressao ' + JSON.stringify(data));
            self.confirmarImpressao(data);
        });

    }

    criarArquivo(data) {

        var resposta = this.getRespostaPadrao();

        this.criarArquivoAguardarResposta(data, 'P2').then((conteudo) => {
            this.log("Retorno do passo P2:\r\n" + conteudo);
            this.enviarResposta({error: 0, msg: null, conteudoArquivo: conteudo, passo: 'P2'});
            return this.passoP4();
        }).then((conteudo) => {
            this.log('Enviando resposta do passo P4: ' + JSON.stringify(conteudo));
            this.enviarResposta({error: 0, msg: null, conteudoArquivo: conteudo, passo: 'P4'});
        }).catch((e) => {
            resposta.error = 1;
            resposta.msg = e.toString();
            this.log('Erro no metodo criarArquivo, bloco catch: ' + JSON.stringify(resposta));
            this.enviarResposta(resposta);
        })
    }

    confirmarImpressao(dados) {
        var self = this;
        this.criarArquivoAguardarResposta(dados, 'P7').then(function (conteudo) {
            let resposta = {error: 0, msg: null, conteudoArquivo: conteudo, passo: 'P7'};
            self.log('Enviando resposta passo P7: ' + JSON.stringify());
            self.enviarResposta(resposta);
        });
    }

    criarArquivoAguardarResposta(data, passo) {

        return new Promise((resolve, reject) => {
            var conteudo = data.conteudoArquivo;
            this.data = data;
            var destinoFinal = this.config.sitef.pastaDestinoReq + 'IntPos.001';

            if (data.arquivoDestino) {
                destinoFinal = this.config.sitef.pastaDestinoReq + data.arquivoDestino;
            }

            var arquivoEsperado = this.config.sitef.pastaDestinoResp + 'IntPos.STS';
            if (fs.existsSync(arquivoEsperado)) {
                return reject(new Error('Já existe um arquivo ' + arquivoEsperado + ' na pasta!'));
            }

            var arquivoEsperadoP4 = this.config.sitef.pastaDestinoResp + 'IntPos.001';

            if (fs.existsSync(arquivoEsperadoP4)) {
                this.moverArquivoP4(arquivoEsperadoP4);
                //return reject(new Error('Já existe um arquivo ' + arquivoEsperadoP4 + ' na pasta!'));
            }

            var arquivoTmp = this.config.sitef.pastaDestinoReq + 'IntPos.tmp';
            var descriptor = fs.openSync(arquivoTmp, 'w');
            fs.writeSync(descriptor, conteudo);
            fs.closeSync(descriptor);
            fs.renameSync(arquivoTmp, destinoFinal);
            this.log('Criado o arquivo ' + destinoFinal);
            var self = this;

            var numeroTentativas = 0;
            var timerId = setInterval(function () {
                self.log('Verificando se arquivo ' + arquivoEsperado + ' existe!');
                if (!fs.existsSync(arquivoEsperado)) {
                    numeroTentativas++;
                    if (numeroTentativas > 20) {
                        clearInterval(timerId);
                        fs.unlinkSync(destinoFinal);
                        return reject(new Error("SITEF não está respondendo. Verifique se os programas estão abertos e o pinpad ligado!"));
                    }
                    return;
                }
                self.log('Arquivo ' + arquivoEsperado + ' encontrado');
                clearInterval(timerId);
                try {
                    console.log(arquivoEsperado);
                    var conteudo = fs.readFileSync(arquivoEsperado);
                    self.log('Conteudo do arquivo lido');
                    self.log(conteudo);
                    fs.unlinkSync(arquivoEsperado);
                    return resolve(conteudo);
                } catch (e) {
                    return reject(new Error("Erro ao ler o arquivo " + arquivoEsperado + "!"));
                }

            }, 400);
        });
    }

    passoP4() {
        return new Promise((resolve, reject) => {
            var arquivoEsperadoP4 = this.config.sitef.pastaDestinoResp + 'IntPos.001';
            var self = this;
            var timerArquivoP4 = setInterval(() => {
                console.log('Verificando se arquivo do passo P4 existe!');

                if (!fs.existsSync(arquivoEsperadoP4)) {
                    return;
                }
                self.log('Arquivo do passo P4 encontrado');
                clearInterval(timerArquivoP4);
                fs.readFile(arquivoEsperadoP4, (err, data) => {
                    self.log("Retorno leitura arquivo passo P4 erro: " + err);
                    self.log("Retorno leitura arquivo passo P4 dados:\r\n" + data);
                    if (err) {
                        self.log("Enviando resposta erro passo P4");
                        return reject(new Error("Erro ao ler o arquivo do passo P4!"));
                    }

                    self.moverArquivoP4(arquivoEsperadoP4);

                    self.log('Chamando metodo resolve do passo P4');
                    return resolve(data);
                });
            }, 500);
        });
    }

    verificarArquivoP4() {
        var arquivoEsperadoP4 = this.config.sitef.pastaDestinoResp + 'IntPos.001';
        this.log('Verificando se arquivo do passo P4 existe na inicialização!');
        if (!fs.existsSync(arquivoEsperadoP4)) {
            this.log('Não há, saindo...');
            return;
        }

        this.log('Arquivo do passo P4 na inicialização encontrado!');
        var self = this;
        fs.readFile(arquivoEsperadoP4, (err, data) => {
            if (err) {
                return reject(new Error("Erro ao ler o arquivo do passo P4!"));
            }
            fs.unlinkSync(arquivoEsperadoP4);
            self.log("Enviando o arquivo no metodo verificarArquivoP4/sitef_tratar_queda_energia\r\n" + data);
            this.socketio.emit('sitef_tratar_queda_energia', {error: 0, msg: null, conteudoArquivo: data});
        });

    }

    enviarResposta(dados) {
        this.log('Enviando resposta ' + JSON.stringify(dados));
        this.socketio.emit('sitef_resposta', dados);
    }

    getRespostaPadrao() {
        return {
            error: 0,
            msg: null
        };
    }

    moverArquivoP4(arquivo) {
        this.log('Movendo arquivo passo P4');
        let data = new Date();
        let ano = data.getFullYear();
        let mes = data.getMonth() + 1;
        let dia = data.getDate();
        let hora = data.getHours();
        let minuto = data.getMinutes();
        let segundo = data.getSeconds();
        let milisegundos = data.getMilliseconds();

        if (dia < 10) {
            dia = "0" + dia;
        }

        if (hora < 10) {
            hora = "0" + hora;
        }

        if (minuto < 10) {
            minuto = "0" + minuto;
        }

        if (segundo < 10) {
            segundo = "0" + segundo;
        }

        let pasta = this.config.pastaBase + '/arquivos/sitef/' + ano;

        if (!fs.existsSync(pasta)) {
            fs.mkdirSync(pasta);
        }

        pasta = pasta + '/' + mes;

        if (!fs.existsSync(pasta)) {
            fs.mkdirSync(pasta);
        }
        let destino = pasta + '/' + dia + '-' + hora + '-' + minuto + '-' + segundo + '-' + milisegundos + '-p4.txt';

        fs.renameSync(arquivo, destino);
        this.log('Foi movido arquivo do passo P4 de ' + arquivo + ' para ' + destino);
    }

    log(str) {
        this.criarPastasLog();

        let data = new Date();
        let ano = data.getFullYear();
        let mes = data.getMonth() + 1;
        let dia = data.getDate();

        str = data.toISOString() + ' ' + str + "\r\n";

        let arquivoLog = this.config.pastaLogs + ano + '/' + mes + '/' + dia + '-sitef.log';

        var descriptor = fs.openSync(arquivoLog, 'a+');
        fs.writeSync(descriptor, str);
        fs.closeSync(descriptor);
    }

    criarPastasLog() {
        if (this.pastasLogCriadas) {
            return true;
        }

        let data = new Date();
        let ano = data.getFullYear();
        let mes = data.getMonth() + 1;

        if (!fs.existsSync(this.config.pastaLogs)) {
            fs.mkdirSync(this.config.pastaLogs);
        }

        if (!fs.existsSync(this.config.pastaLogs + ano)) {
            fs.mkdirSync(this.config.pastaLogs + ano);
        }

        if (!fs.existsSync(this.config.pastaLogs + ano + '/' + mes)) {
            fs.mkdirSync(this.config.pastaLogs + ano + '/' + mes);
        }

        this.pastasLogCriadas = true;
    }
}
