<?php

namespace Oneweb\SimuladorSitef;

/**
 * Description of SitefRegistro
 *
 * @author Gerson Felipe Schwinn <gerson@onehost.com.br>
 */
class SitefRegistro implements \Stringable
{
    private string $identificacao;
    private int $nSequencia;
    private string $conteudo;

    /**
     * @return self
     */
    public static function create(string $identificacao, string $conteudo, ?int $nSequencia = null)
    {
        if ($nSequencia === null) {
            $nSequencia = 0;
        }

        if ($identificacao == 999) {
            $nSequencia = 999;
        }

        return (new SitefRegistro())
            ->setIdentificacao($identificacao)
            ->setConteudo($conteudo)
            ->setNSequencia($nSequencia);
    }

    public static function createFromString(string $str): SitefRegistro|false
    {
        $partesString = explode(' = ', $str);
        if (count($partesString) < 2) {
            return false;
        }

        [$prefixo, $conteudo] = $partesString;
        [$identificacao, $nSequencia] = explode('-', $prefixo);

        return (new SitefRegistro())
            ->setIdentificacao($identificacao)
            ->setConteudo(trim($conteudo))
            ->setNSequencia($nSequencia);
    }

    public function __toString(): string
    {
        return sprintf('%03d', $this->identificacao) . '-' .
            sprintf('%03d', $this->nSequencia) . ' = ' .
            $this->conteudo . "\r\n";
    }

    public function getIdentificacao(): string
    {
        return $this->identificacao;
    }

    public function setIdentificacao(string $identificacao): self
    {
        $this->identificacao = $identificacao;

        return $this;
    }

    public function getNSequencia(): int
    {
        return $this->nSequencia;
    }

    public function getConteudo(): string
    {
        return $this->conteudo;
    }

    public function setNSequencia(int|string $nSequencia): self
    {
        $this->nSequencia = (int)$nSequencia;

        return $this;
    }

    public function setConteudo(string $conteudo): self
    {
        $this->conteudo = $conteudo;

        return $this;
    }

    public function adicionarConteudo(string $novoConteudo): static
    {
        $this->conteudo = $this->conteudo . ' ' . $novoConteudo;

        return $this;
    }
}
